/*------------------------------------------------------------------------------*
 * File Name: CurvesEx.c														*
 * Creation: GJL 3/29/2005														*
 * Purpose: OriginC Source C file containing a Curve example.					*
 * Copyright (c) OriginLab Corp.	2005, 2006, 2007, 2008, 2009, 2010			*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/

#include <Origin.h>

// A worksheet with data in first two columns must be active prior to execution
void CurveEx()
{
	Worksheet wks = Project.ActiveLayer(); // Get active worksheet
	if( wks ) // If wks is valid...
	{
		Curve crv(wks, 0, 1); // Get curve in columns 0 (X) and 1 (Y) of wks
		GraphPage gp; // Construct OC GraphPage object named gp
		gp.Create("Scatter.otp"); // Create Origin graph and attach to gp
		if( crv && gp ) // If crv and gp are valid...
		{
			GraphLayer gl = gp.Layers(0); // Get GraphLayer and attach to object named gl
			if( gl ) // If gl is valid...
			{
				int iIndex = gl.AddPlot(crv, IDM_PLOT_SCATTER); // Plot crv in layer 
				gl.Rescale(); // Rescale plot according to data range
				gl.LT_execute("sec -p .1"); // Force redraw
				IntegrationResult ir; // Origin C structure to store integration results
				if( Curve_integrate( &crv, &ir, NULL, NULL, TRUE ) ) // Perform integration
					printf( "Area = %f\n", ir.Area); // Output area
			}
		}
	}
}
